# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui
from qgis.core import *
from qgis.gui import *
from SimulateUi import Ui_Form
from ClickFeature import ClickFeature
from datetime import datetime
import os
import common
import const
import math
import glob

# ダイアログクラス
class SimulateDialog(QWidget, Ui_Form):

    def __init__(self, iface):
        QWidget.__init__(self)

        self.ui = Ui_Form()
        self.ui.setupUi(self)
        self.ui.btnPdf.setIcon(QIcon(":/plugins/HydropowerPotential/icon_print.png"))
        self.ui.btnClear.setIcon(QIcon(":/plugins/HydropowerPotential/icon_clear.png"))
        self.ui.btnCalc.setIcon(QIcon(":/plugins/HydropowerPotential/SimulateIcon.png"))

        self.iface = iface
        self.canvas = self.iface.mapCanvas()

        #マップツールの定義
        #self.thisMapTool = ClickAnywhere(self.canvas)
        self.thisMapTool = ClickFeature(self.canvas, 'all_list')
        self.thisMapTool.geomIdentified.connect(self.set_shusuiten)
        self.thisMapTool.pointClicked.connect(self.draw_line)
        self.thisMapTool.pointDbClicked.connect(self.draw_line_last)
        self.canvas.setMapTool(self.thisMapTool)

        self.ui.btnCalc.released.connect(self.calc_exe)
        self.ui.btnClip.released.connect(self.clip_result)

        self.ui.btnPdf.released.connect(self.print_map)
        self.ui.btnClear.released.connect(self.clear)

        self.ui.btnToM.released.connect(self.to_m_exe)
        self.ui.btnToHi.released.connect(self.to_hi_exe)

        self.ui.btnNewCase.released.connect(self.new_case)

        self.init_form()

    def init_form(self):
        self.ui.tabResult.setVisible(False)
        self.ui.lbHint.setVisible(True)
        self.ui.btnPdf.setVisible(False)
        self.ui.btnClip.setVisible(False)
        self.ui.btnClear.setVisible(False)
        self.ui.btnNewCase.setVisible(False)

        #---ライン削除
        self.erase_line()

        #テンポラリーレイヤー
        self.line_vl = QgsVectorLayer("LineString?crs=epsg:4612", u"導水管ライン", "memory")
        renderer = self.line_vl.rendererV2()
        symbol = QgsLineSymbolV2.createSimple({u'line_color': u'255,0,0,128',u'line_width': u'1.4'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.line_vl],False)
        self.line_pr = self.line_vl.dataProvider()

        self.shusuiten_vl = QgsVectorLayer("Point?crs=epsg:4612", u"取水点", "memory")
        renderer = self.shusuiten_vl.rendererV2()
        symbol = QgsMarkerSymbolV2.createSimple({u'color': u'255,0,0,255', u'size': u'3', u'name': u'triangle'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.shusuiten_vl],False)
        self.shusuiten_pr = self.shusuiten_vl.dataProvider()

        self.hosuiten_vl = QgsVectorLayer("Point?crs=epsg:4612", u"放水点", "memory")
        renderer = self.hosuiten_vl.rendererV2()
        symbol = QgsMarkerSymbolV2.createSimple({u'color': u'255,0,0,255', u'size': u'3', u'name': u'square'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.hosuiten_vl],False)
        self.hosuiten_pr = self.hosuiten_vl.dataProvider()

        self.line2_vl = QgsVectorLayer("LineString?crs=epsg:4612", u"導水管ライン2", "memory")
        renderer = self.line2_vl.rendererV2()
        symbol = QgsLineSymbolV2.createSimple({u'line_color': u'0,0,255,128',u'line_width': u'1.4'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.line2_vl],False)
        self.line2_pr = self.line2_vl.dataProvider()

        self.shusuiten2_vl = QgsVectorLayer("Point?crs=epsg:4612", u"取水点2", "memory")
        renderer = self.shusuiten2_vl.rendererV2()
        symbol = QgsMarkerSymbolV2.createSimple({u'color': u'0,0,255,255', u'size': u'3', u'name': u'triangle'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.shusuiten2_vl],False)
        self.shusuiten2_pr = self.shusuiten2_vl.dataProvider()

        self.hosuiten2_vl = QgsVectorLayer("Point?crs=epsg:4612", u"放水点2", "memory")
        renderer = self.hosuiten2_vl.rendererV2()
        symbol = QgsMarkerSymbolV2.createSimple({u'color': u'0,0,255,255', u'size': u'3', u'name': u'square'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.hosuiten2_vl],False)
        self.hosuiten2_pr = self.hosuiten2_vl.dataProvider()

        self.line3_vl = QgsVectorLayer("LineString?crs=epsg:4612", u"導水管ライン3", "memory")
        renderer = self.line3_vl.rendererV2()
        symbol = QgsLineSymbolV2.createSimple({u'line_color': u'0,187,0,128',u'line_width': u'1.4'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.line3_vl],False)
        self.line3_pr = self.line3_vl.dataProvider()

        self.shusuiten3_vl = QgsVectorLayer("Point?crs=epsg:4612", u"取水点3", "memory")
        renderer = self.shusuiten3_vl.rendererV2()
        symbol = QgsMarkerSymbolV2.createSimple({u'color': u'0,187,0,255', u'size': u'3', u'name': u'triangle'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.shusuiten3_vl],False)
        self.shusuiten3_pr = self.shusuiten3_vl.dataProvider()

        self.hosuiten3_vl = QgsVectorLayer("Point?crs=epsg:4612", u"放水点3", "memory")
        renderer = self.hosuiten3_vl.rendererV2()
        symbol = QgsMarkerSymbolV2.createSimple({u'color': u'0,187,0,255', u'size': u'3', u'name': u'square'})
        renderer.setSymbol(symbol)
        QgsMapLayerRegistry.instance().addMapLayers([self.hosuiten3_vl],False)
        self.hosuiten3_pr = self.hosuiten3_vl.dataProvider()

        self.tree_root = QgsProject.instance().layerTreeRoot()
        self.group_vl = self.tree_root.insertGroup(0, const.TEMP_GROUP_NAME)

        self.group_vl.addLayer(self.shusuiten_vl)
        self.group_vl.addLayer(self.hosuiten_vl)
        self.group_vl.addLayer(self.line_vl)

        self.group_vl.addLayer(self.shusuiten2_vl)
        self.group_vl.addLayer(self.hosuiten2_vl)
        self.group_vl.addLayer(self.line2_vl)

        self.group_vl.addLayer(self.shusuiten3_vl)
        self.group_vl.addLayer(self.hosuiten3_vl)
        self.group_vl.addLayer(self.line3_vl)

        self.group_vl.setExpanded(False)

        #新規：初期化
        self.case1_clear()

    def  case1_clear(self):
        self.ui.lblAlert.setText(u"")
        self.ui.lblAlertJoken.setText(u"")

        common.setText(self.ui.z_SegmentID, "", "str")
        common.setText(self.ui.z_Elevation, "", "str")
        common.setText(self.ui.z_AccumWSA, "", "str")
        common.setText(self.ui.z_Qmaxr, "", "str")
        common.setText(self.ui.z_BlockID, "", "str")
        common.setText(self.ui.z_BlockName, "", "str")
        common.setText(self.ui.z_BlockQmax, "", "str")
        common.setText(self.ui.z_BlockBA, "", "str")
        common.setText(self.ui.z_Road, "", "str")
        common.setText(self.ui.h_Elevation, "", "str")
        common.setText(self.ui.r_Qmaxr, "", "str")
        common.setText(self.ui.j_Qmaxr, "", "str")
        common.setText(self.ui.r_Rakusa, "", "str")
        common.setText(self.ui.r_Kyori, "", "str")
        common.setText(self.ui.j_KaikyoHi, 50, "int")
        common.setText(self.ui.j_AnkyoHi, 30, "int")
        common.setText(self.ui.j_SuiatsuHi, 20, "int")
        common.setText(self.ui.j_KaikyoM, "", "str")
        common.setText(self.ui.j_AnkyoM, "", "str")
        common.setText(self.ui.j_SuiatsuM, "", "str")
        self.ui.j_ShusuiNew.setChecked(True)
        common.setText(self.ui.r_Setsubi, "", "str")
        common.setText(self.ui.r_Hatsudensho, "", "str")
        common.setText(self.ui.r_ShusuiShisetsu, "", "str")
        common.setText(self.ui.r_Chinsachi, "", "str")
        common.setText(self.ui.r_DosuiShisetsu, "", "str")
        common.setText(self.ui.r_HosuiShisetsu, "", "str")
        common.setText(self.ui.r_KikaiDenki, "", "str")
        common.setText(self.ui.r_Gokei, "", "str")
        common.setText(self.ui.r_Tanka, "", "str")

        #---選択点クリアー
        self.previous_pos = ""
        self.r_Kyori = 0
        self.hosui_selected = False

        #---レイヤークリアー
        common.deleteAllFeatureWithCommit(self.shusuiten_vl)
        common.deleteAllFeatureWithCommit(self.hosuiten_vl)
        common.deleteAllFeatureWithCommit(self.line_vl)

        #マウスカーソル戻す
        QApplication.restoreOverrideCursor()
        QApplication.restoreOverrideCursor()    #2回呼び出す必要


    def set_shusuiten(self, layer, feature, event):

        if self.previous_pos == "" :

            if layer.name() == const.ZONE_LYR_NAME:
                #初回のポイント
                fet = QgsFeature()
                geo = QgsGeometry.fromPoint(QgsPoint(self.thisMapTool.toMapCoordinates(event.pos())))
                fet.setGeometry( geo )

                self.shusuiten_pr.addFeatures( [ fet ] )
                self.shusuiten_vl.updateExtents()
                self.shusuiten_vl.triggerRepaint()

                QApplication.setOverrideCursor(Qt.CrossCursor)

                self.ui.lbHint.setVisible(False)
                self.ui.tabResult.setVisible(True)
                self.ui.tabResult.setCurrentIndex(0)
                self.ui.btnClear.setVisible(True)

                self.previous_pos = QgsPoint(self.thisMapTool.toMapCoordinates(event.pos()))

                #属性の表示
                common.setText(self.ui.z_SegmentID, feature["SegmentID"], "int")
                common.setText(self.ui.z_Elevation, feature["Elevation"], "int")
                common.setText(self.ui.z_AccumWSA, feature["AccumWSA"], "flt1")
                common.setText(self.ui.z_Qmaxr, feature["Qmaxr"], "flt2")
                common.setText(self.ui.z_BlockID, feature["BlockID"], "int")
                common.setText(self.ui.z_BlockName, feature["BlockName"], "str")
                common.setText(self.ui.z_BlockQmax, feature["BlockQmax"], "flt2")
                common.setText(self.ui.z_BlockBA, feature["BlockBA"], "flt1")
                common.setText(self.ui.z_Road, feature["Road"], "flt1")

                common.setText(self.ui.r_Qmaxr, feature["Qmaxr"], "flt3")
                common.setText(self.ui.j_Qmaxr, feature["Qmaxr"], "flt3")

                #変数に値をセット
                self.z_Elevation = feature["Elevation"]
                self.sansho = feature["ObservedP"]

    def draw_line(self, event):

        if self.previous_pos != "" and self.hosui_selected == False:

            #ライン
            fet = QgsFeature()
            new_point = QgsPoint(self.thisMapTool.toMapCoordinates(event.pos()))
            geo = QgsGeometry.fromPolyline([self.previous_pos, new_point])
            fet.setGeometry( geo )

            self.line_pr.addFeatures( [ fet ] )
            self.line_vl.updateExtents()
            self.line_vl.triggerRepaint()

            #計算実行
            kyori = common.calcM(self.previous_pos.x(), self.previous_pos.y(), new_point.x(), new_point.y())
            self.r_Kyori += kyori

            self.previous_pos = QgsPoint(self.thisMapTool.toMapCoordinates(event.pos()))

    def draw_line_last(self, event):

        if self.previous_pos != "" and self.hosui_selected == False:

            #標高取得
            hyoko = common.getHyoko(self, event.pos())
            if hyoko!=False:
                common.setText(self.ui.h_Elevation, hyoko, "int")
            else:
                return

            #最終ポイント
            fet = QgsFeature()
            geo = QgsGeometry.fromPoint(QgsPoint(self.thisMapTool.toMapCoordinates(event.pos())))
            fet.setGeometry( geo )

            self.hosuiten_pr.addFeatures( [ fet ] )
            self.hosuiten_vl.updateExtents()
            self.hosuiten_vl.triggerRepaint()

            self.ui.tabResult.setCurrentIndex(2)

            self.hosui_selected = True

            #値を変数へ
            self.h_Elevation = hyoko

            #---導水管長
            common.setText(self.ui.r_Kyori, self.r_Kyori, "flt1")

            #---延長を計算
            kaijyoHi = float(self.ui.j_KaikyoHi.text().replace(",",""))
            ankyoHi = float(self.ui.j_AnkyoHi.text().replace(",",""))
            suiatsuHi = float(self.ui.j_SuiatsuHi.text().replace(",",""))

            kyori = float(self.ui.r_Kyori.text().replace(",",""))
            kaijyoM = kyori * kaijyoHi / 100.0
            ankyoM = kyori * ankyoHi / 100.0
            suiatsuM = kyori * suiatsuHi / 100.0

            common.setText(self.ui.j_KaikyoM, kaijyoM, "flt1")
            common.setText(self.ui.j_AnkyoM, ankyoM, "flt1")
            common.setText(self.ui.j_SuiatsuM, suiatsuM, "flt1")

            #---有効落差
            r_Rakusa = self.z_Elevation - self.h_Elevation - (self.r_Kyori / 500)
            if round(r_Rakusa * 10) / 10 <= 0:
                self.ui.lblAlert.setText(u"有効落差が0以下になりました。\nシミュレーションをやり直してください。")
                self.ui.tabResult.setCurrentIndex(1)
                return

            common.setText(self.ui.r_Rakusa, r_Rakusa, "flt1")

            QApplication.setOverrideCursor(Qt.ArrowCursor)

    def erase_line(self):

        try:
            #テンポラリーレイヤー削除
            common.deleteToolLayer()
        except:
            pass

    def clear(self):
        self.case1_clear()

        self.ui.tabResult.setCurrentIndex(0)

        self.ui.btnPdf.setVisible(False)
        self.ui.btnClip.setVisible(False)
        self.ui.btnNewCase.setVisible(False)

    def to_m_exe(self):

        try:
            kaijyoHi = float(self.ui.j_KaikyoHi.text().replace(",",""))
            ankyoHi = float(self.ui.j_AnkyoHi.text().replace(",",""))
            suiatsuHi = float(self.ui.j_SuiatsuHi.text().replace(",",""))

            kyori = float(self.ui.r_Kyori.text().replace(",",""))
            kaijyoM = kyori * kaijyoHi / 100.0
            ankyoM = kyori * ankyoHi / 100.0
            suiatsuM = kyori * suiatsuHi / 100.0

            common.setText(self.ui.j_KaikyoM, kaijyoM, "flt1")
            common.setText(self.ui.j_AnkyoM, ankyoM, "flt1")
            common.setText(self.ui.j_SuiatsuM, suiatsuM, "flt1")

        except:
            self.ui.lblAlertJoken.setText(u"延長比は半角数字で入力してください。")
            return

    def to_hi_exe(self):

        try:
            kaijyoM = float(self.ui.j_KaikyoM.text().replace(",",""))
            ankyoM = float(self.ui.j_AnkyoM.text().replace(",",""))
            suiatsuM = float(self.ui.j_SuiatsuM.text().replace(",",""))

            kyori = float(self.ui.r_Kyori.text().replace(",",""))
            kaijyoHi = kaijyoM / kyori * 100.0
            ankyoHi = ankyoM / kyori * 100.0
            suiatsuHi = suiatsuM / kyori * 100.0

            common.setText(self.ui.j_KaikyoHi, kaijyoHi, "flt1")
            common.setText(self.ui.j_AnkyoHi, ankyoHi, "flt1")
            common.setText(self.ui.j_SuiatsuHi, suiatsuHi, "flt1")

        except:
            self.ui.lblAlertJoken.setText(u"延長は半角数字で入力してください。")
            return

    def calc_exe(self):

        try:
            qmaxr = float(self.ui.r_Qmaxr.text().replace(",",""))
            rakusa = float(self.ui.r_Rakusa.text().replace(",",""))
            kyori = float(self.ui.r_Kyori.text().replace(",",""))

            self.to_hi_exe()

            kaikyoHi = float(self.ui.j_KaikyoHi.text().replace(",",""))
            ankyoHi = float(self.ui.j_AnkyoHi.text().replace(",",""))
            suiatsuHi = float(self.ui.j_SuiatsuHi.text().replace(",",""))

            kaikyoM = float(self.ui.j_KaikyoM.text().replace(",",""))
            ankyoM = float(self.ui.j_AnkyoM.text().replace(",",""))
            suiatsuM = float(self.ui.j_SuiatsuM.text().replace(",",""))
        except:
            self.ui.lblAlertJoken.setText(u"値は半角数字で入力してください。")
            return

        if kaikyoHi + ankyoHi + suiatsuHi != 100:

            ret = QMessageBox.information(None, u"ご確認ください。", u"導水管長と導水管種の延長の合計が一致しません。　計算を続けますか。", QMessageBox.Yes, QMessageBox.No)
            if ret == QMessageBox.No:
                return

        #---設備容量
        r_Setsubi = qmaxr * rakusa * const.SETSUBI_YORYO_KEISU * const.KORITESU
        common.setText(self.ui.r_Setsubi, r_Setsubi, "flt1")

        #---発電所建物
        r_Hatsudensho = const.SETSUBI_RIYORITSU * (r_Setsubi ** const.HATUDENSHO_KEISU1) * 1000
        common.setText(self.ui.r_Hatsudensho, r_Hatsudensho, "flt1")

        #---取水堰
        if self.ui.j_ShusuiOld.isChecked():
            r_Dam = 0
        else:
            qmaxr_max = qmaxr / const.SETSUBI_RIYORITSU
            koteisa_dam = qmaxr_max * const.KOTEISA_DAM_KEISU
            concrete = const.CONCRETE_KEISU1 * (koteisa_dam ** const.CONCRETE_KEISU2)
            r_Dam = const.DAM_KEISU1 * (concrete ** const.DAM_KEISU2) * 1000

        #---取水口
        if qmaxr < const.SHUSUIKO_RYURYO_KBN:
            suiro_naikei = const.SUIRO_NAIKEI_KEISU1
        else:
            suiro_naikei = const.SUIRO_NAIKEI_KEISU2 * (qmaxr**const.SUIRO_NAIKEI_KEISU3)
        r_Shusuiko = const.SHUSUIKO_KEISU1 * ( (suiro_naikei * qmaxr) ** const.SHUSUIKO_KEISU2 ) * 1000

        common.setText(self.ui.r_ShusuiShisetsu, r_Dam + r_Shusuiko, "flt1")

        #---沈砂池・水槽等
        r_Chinsachi = const.CHINSAI_KEISU1 * (qmaxr ** const.CHINSAI_KEISU2) * 1000

        common.setText(self.ui.r_Chinsachi, r_Chinsachi, "flt1")

        #---開きょ
        haba_takasa = const.KAIKYO_KEISU1 * (qmaxr ** const.KAIKYO_KEISU2)
        r_Kaikyo = const.KAIKYO_KEISU3 * (haba_takasa ** const.KAIKYO_KEISU4) * kaikyoM

        #---暗きょ
        r_Ankyo = const.ANKYO_KEISU1 * (haba_takasa ** const.ANKYO_KEISU2) * ankyoM

        #---水圧管路
        naikei = const.NAIKEI_KEISU1 * (qmaxr ** const.NAIKEI_KEISU2)
        r_SuiatsuKanro = const.SUIATSU_KANRO_KEISU1 * (naikei ** const.SUIATSU_KANRO_KEISU2) * suiatsuM

        #---鉄管
        tanijuryo = const.TEKKAN_KEISU1 * (qmaxr ** const.TEKKAN_KEISU2)
        juryo = tanijuryo * suiatsuM
        tanka = const.TEKKAN_KEISU3 * (juryo ** const.TEKKAN_KEISU4)
        r_Tekkan = tanka * juryo

        common.setText(self.ui.r_DosuiShisetsu, r_Kaikyo + r_Ankyo + r_SuiatsuKanro + r_Tekkan, "flt1")

        #---放水口
        r_Hosuiko = const.HOSUIKO_KEISU1 * ( (naikei * qmaxr) ** const.HOSUIKO_KEISU2 ) * 1000

        common.setText(self.ui.r_HosuiShisetsu, r_Hosuiko, "flt1")

        #---機械装置基礎
        r_Kikai = const.KIKAI_KEISU1 *  ( (qmaxr * (rakusa ** const.KIKAI_KEISU2) * (const.KIKAI_DAISU ** const.KIKAI_KEISU3) ) ** const.KIKAI_KEISU4 ) * 1000

        #---電気設備工事費
        if r_Setsubi < const.DENKI_KBN:
            r_Denki = const.DENKI_KEISU1 * ((r_Setsubi / math.sqrt(rakusa))**const.DENKI_KEISU2) * 1000
        else:
            r_Denki = const.DENKI_KEISU3 * ( (r_Setsubi / math.sqrt(rakusa)) ** const.DENKI_KEISU4 ) * 1000

        common.setText(self.ui.r_KikaiDenki, r_Kikai + r_Denki, "flt1")

        #---概算工事費合計
        r_Gokei = r_Hatsudensho + r_Dam + r_Shusuiko + r_Chinsachi + r_Kaikyo + r_Ankyo + r_SuiatsuKanro + r_Tekkan +r_Hosuiko + r_Kikai + r_Denki
        common.setText(self.ui.r_Gokei, r_Gokei, "flt1")

        #---建設単価
        r_Tanka = r_Gokei / r_Setsubi
        common.setText(self.ui.r_Tanka, r_Tanka, "flt1")

        #表示タブ変更
        self.ui.tabResult.setCurrentIndex(3)
        self.ui.btnPdf.setVisible(True)
        self.ui.btnClip.setVisible(True)
        self.ui.btnNewCase.setVisible(True)

    def new_case(self):
        #---前回→前々回
        self.ui.z_SegmentID_3.setText(self.ui.z_SegmentID_2.text())
        self.ui.z_Elevation_3.setText(self.ui.z_Elevation_2.text())
        self.ui.z_AccumWSA_3.setText(self.ui.z_AccumWSA_2.text())
        self.ui.z_Qmaxr_3.setText(self.ui.z_Qmaxr_2.text())
        self.ui.z_BlockID_3.setText(self.ui.z_BlockID_2.text())
        self.ui.z_BlockName_3.setText(self.ui.z_BlockName_2.text())
        self.ui.z_BlockQmax_3.setText(self.ui.z_BlockQmax_2.text())
        self.ui.z_BlockBA_3.setText(self.ui.z_BlockBA_2.text())
        self.ui.z_Road_3.setText(self.ui.z_Road_2.text())

        self.ui.h_Elevation_3.setText(self.ui.h_Elevation_2.text())

        self.ui.r_Qmaxr_4.setText(self.ui.r_Qmaxr_2.text())
        self.ui.j_Qmaxr_4.setText(self.ui.j_Qmaxr_2.text())
        self.ui.r_Rakusa_4.setText(self.ui.r_Rakusa_2.text())
        self.ui.r_Kyori_4.setText(self.ui.r_Kyori_2.text())
        self.ui.j_KaikyoHi_4.setText(self.ui.j_KaikyoHi_2.text())
        self.ui.j_AnkyoHi_4.setText(self.ui.j_AnkyoHi_2.text())
        self.ui.j_SuiatsuHi_4.setText(self.ui.j_SuiatsuHi_2.text())
        self.ui.j_KaikyoM_4.setText(self.ui.j_KaikyoM_2.text())
        self.ui.j_AnkyoM_4.setText(self.ui.j_AnkyoM_2.text())
        self.ui.j_SuiatsuM_4.setText(self.ui.j_SuiatsuM_2.text())
        if self.ui.j_ShusuiOld_2.isChecked():
            self.ui.j_ShusuiOld_4.setChecked(True)
        else:
            self.ui.j_ShusuiNew_4.setChecked(True)

        self.ui.r_Setsubi_4.setText(self.ui.r_Setsubi_3.text())
        self.ui.r_Hatsudensho_4.setText(self.ui.r_Hatsudensho_3.text())
        self.ui.r_ShusuiShisetsu_4.setText(self.ui.r_ShusuiShisetsu_3.text())
        self.ui.r_Chinsachi_4.setText(self.ui.r_Chinsachi_3.text())
        self.ui.r_DosuiShisetsu_4.setText(self.ui.r_DosuiShisetsu_3.text())
        self.ui.r_HosuiShisetsu_4.setText(self.ui.r_HosuiShisetsu_3.text())
        self.ui.r_KikaiDenki_4.setText(self.ui.r_KikaiDenki_3.text())
        self.ui.r_Gokei_4.setText(self.ui.r_Gokei_3.text())
        self.ui.r_Tanka_4.setText(self.ui.r_Tanka_3.text())

        common.copyFeature(self.shusuiten2_vl, self.shusuiten3_vl)
        common.copyFeature(self.hosuiten2_vl, self.hosuiten3_vl)
        common.copyFeature(self.line2_vl, self.line3_vl)

        #---新規→前回
        self.ui.z_SegmentID_2.setText(self.ui.z_SegmentID.text())
        self.ui.z_Elevation_2.setText(self.ui.z_Elevation.text())
        self.ui.z_AccumWSA_2.setText(self.ui.z_AccumWSA.text())
        self.ui.z_Qmaxr_2.setText(self.ui.z_Qmaxr.text())
        self.ui.z_BlockID_2.setText(self.ui.z_BlockID.text())
        self.ui.z_BlockName_2.setText(self.ui.z_BlockName.text())
        self.ui.z_BlockQmax_2.setText(self.ui.z_BlockQmax.text())
        self.ui.z_BlockBA_2.setText(self.ui.z_BlockBA.text())
        self.ui.z_Road_2.setText(self.ui.z_Road.text())

        self.ui.h_Elevation_2.setText(self.ui.h_Elevation.text())

        self.ui.r_Qmaxr_2.setText(self.ui.r_Qmaxr.text())
        self.ui.j_Qmaxr_2.setText(self.ui.j_Qmaxr.text())
        self.ui.r_Rakusa_2.setText(self.ui.r_Rakusa.text())
        self.ui.r_Kyori_2.setText(self.ui.r_Kyori.text())
        self.ui.j_KaikyoHi_2.setText(self.ui.j_KaikyoHi.text())
        self.ui.j_AnkyoHi_2.setText(self.ui.j_AnkyoHi.text())
        self.ui.j_SuiatsuHi_2.setText(self.ui.j_SuiatsuHi.text())
        self.ui.j_KaikyoM_2.setText(self.ui.j_KaikyoM.text())
        self.ui.j_AnkyoM_2.setText(self.ui.j_AnkyoM.text())
        self.ui.j_SuiatsuM_2.setText(self.ui.j_SuiatsuM.text())
        if self.ui.j_ShusuiOld.isChecked():
            self.ui.j_ShusuiOld_2.setChecked(True)
        else:
            self.ui.j_ShusuiNew_2.setChecked(True)

        self.ui.r_Setsubi_3.setText(self.ui.r_Setsubi.text())
        self.ui.r_Hatsudensho_3.setText(self.ui.r_Hatsudensho.text())
        self.ui.r_ShusuiShisetsu_3.setText(self.ui.r_ShusuiShisetsu.text())
        self.ui.r_Chinsachi_3.setText(self.ui.r_Chinsachi.text())
        self.ui.r_DosuiShisetsu_3.setText(self.ui.r_DosuiShisetsu.text())
        self.ui.r_HosuiShisetsu_3.setText(self.ui.r_HosuiShisetsu.text())
        self.ui.r_KikaiDenki_3.setText(self.ui.r_KikaiDenki.text())
        self.ui.r_Gokei_3.setText(self.ui.r_Gokei.text())
        self.ui.r_Tanka_3.setText(self.ui.r_Tanka.text())

        common.copyFeature(self.shusuiten_vl, self.shusuiten2_vl)
        common.copyFeature(self.hosuiten_vl, self.hosuiten2_vl)
        common.copyFeature(self.line_vl, self.line2_vl)

        #---新規：初期化
        self.case1_clear()

        self.ui.btnPdf.setVisible(False)
        self.ui.btnClip.setVisible(False)
        self.ui.btnNewCase.setVisible(False)

    def clip_result(self):

        str = u"\t新規\t前回\t前々回\t\n"

        str += u"使用可能水量\t" + self.ui.r_Qmaxr.text() + "\t" + self.ui.r_Qmaxr_2.text() + "\t" + self.ui.r_Qmaxr_4.text() + "\tm3/s" + "\n"
        str += u"有効落差\t" + self.ui.r_Rakusa.text() + "\t"  + self.ui.r_Rakusa_2.text() + "\t"  + self.ui.r_Rakusa_4.text() + "\tm" + "\n"
        str += u"導水管長\t" + self.ui.r_Kyori.text() + "\t" + self.ui.r_Kyori_2.text() + "\t" + self.ui.r_Kyori_4.text() + "\tm" + "\n"
        str += u"導水管の延長比(%) 開きょ:暗きょ:水圧管路\t" + self.ui.j_KaikyoHi.text() + ":" + self.ui.j_AnkyoHi.text() + ":" + self.ui.j_SuiatsuHi.text() + "\t" + self.ui.j_KaikyoHi_2.text() + ":" + self.ui.j_AnkyoHi_2.text() + ":" + self.ui.j_SuiatsuHi_2.text() + "\t" + self.ui.j_KaikyoHi_4.text() + ":" + self.ui.j_AnkyoHi_4.text() + ":" + self.ui.j_SuiatsuHi_4.text() + "\n"

        if self.ui.j_ShusuiOld.isChecked():
            str += u"取水堰\t既存"
        else:
            str += u"取水堰\t新規"

        if self.ui.r_Qmaxr_2.text() != "":
            if self.ui.j_ShusuiOld_2.isChecked():
                str += u"\t既存"
            else:
                str += u"\t新規"

        if self.ui.r_Qmaxr_4.text() != "":
            if self.ui.j_ShusuiOld_4.isChecked():
                str += u"\t既存"
            else:
                str += u"\t新規"

        str += "\n"

        str += u"設備容量\t" + self.ui.r_Setsubi.text() + "\t" + self.ui.r_Setsubi_3.text() + "\t" + self.ui.r_Setsubi_4.text() + "\tkW" + "\n"
        str += u"発電所建物\t" + self.ui.r_Hatsudensho.text() + "\t" + self.ui.r_Hatsudensho_3.text() + "\t" + self.ui.r_Hatsudensho_4.text() + u"\t千円" + "\n"
        str += u"取水施設\t" + self.ui.r_ShusuiShisetsu.text() + "\t" + self.ui.r_ShusuiShisetsu_3.text() + "\t" + self.ui.r_ShusuiShisetsu_4.text() + u"\t千円" + "\n"
        str += u"沈砂池・水槽等\t" + self.ui.r_Chinsachi.text() + "\t" + self.ui.r_Chinsachi_3.text() + "\t" + self.ui.r_Chinsachi_4.text() + u"\t千円" + "\n"
        str += u"導水施設\t" + self.ui.r_DosuiShisetsu.text() + "\t" + self.ui.r_DosuiShisetsu_3.text() + "\t" + self.ui.r_DosuiShisetsu_4.text() + u"\t千円" + "\n"
        str += u"放水施設\t" + self.ui.r_HosuiShisetsu.text() + "\t" + self.ui.r_HosuiShisetsu_3.text() + "\t" + self.ui.r_HosuiShisetsu_4.text() + u"\t千円" + "\n"
        str += u"機械・電気設備工事費\t" + self.ui.r_KikaiDenki.text() + "\t" + self.ui.r_KikaiDenki_3.text() + "\t" + self.ui.r_KikaiDenki_4.text() + u"\t千円" + "\n"
        str += u"概算工事費合計\t" + self.ui.r_Gokei.text() + "\t" + self.ui.r_Gokei_3.text() + "\t" + self.ui.r_Gokei_4.text() + u"\t千円" + "\n"
        str += u"建設単価\t" + self.ui.r_Tanka.text() + "\t" + self.ui.r_Tanka_3.text() + "\t" + self.ui.r_Tanka_4.text() + u"\t千円/kW" + "\n"

        clipboard = QApplication.clipboard()
        clipboard.setText(str)

    def print_map(self):

        try:

            QApplication.setOverrideCursor(Qt.WaitCursor)

            filename = "print_" + datetime.now().strftime('%Y%m%d_%H%M%S') + ".pdf"
            filename = os.path.dirname(__file__) + "/temp/" + filename
            try:
                for fl in glob.glob(os.path.dirname(__file__) + "/temp/*.pdf"):
                    os.remove(fl)
            except:
                pass

            mapRenderer = self.canvas.mapRenderer()
            c = QgsComposition(mapRenderer)
            c.setPlotStyle(QgsComposition.Print)

            #A4横
            c.setPaperSize(297, 210)

            #フォント作成
            if os.name == "nt":
                font = QFont("MS PGothic", 8, QFont.Normal)
                font_num = QFont("MS Gothic", 8, QFont.Normal)
                font_sub = QFont("MS Gothic", 12, QFont.Normal)
            else:
                font = QFont("Hiragino Kaku Gothic Pro", 8, QFont.Normal)
                font_num = QFont("Courier", 6, QFont.Normal)
                font_sub = QFont("Hiragino Kaku Gothic Pro", 10, QFont.Normal)

            #マップ
            map = QgsComposerMap(c, 10 ,10, 176, 188)
            map.mDrawCanvasItems = True
            map.setFrameEnabled(True)
            c.addItem(map)

            #方角
            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/direct.png")
            pict.setSceneRect(QRectF(15, 185, 9.17, 10.05))
            c.addComposerPicture(pict)

            #スケール
            item = QgsComposerScaleBar(c)
            item.setStyle('Single Box')
            item.setComposerMap(map)
            item.applyDefaultSize()
            item.setItemPosition(25, 183)
            c.addItem(item)

            #凡例
            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/legend_simulate.png")
            pict.setSceneRect(QRectF(142, 177, 41.98, 16.94))
            c.addComposerPicture(pict)

            #タイトル表示
            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/title.png")
            pict.setSceneRect(QRectF(194, 10, 89.96, 14.82))
            c.addComposerPicture(pict)


            #サブタイトル（取水点および放水点の情報）
            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/simu_info.png")
            pict.setSceneRect(QRectF(194, 30, 89.96, 7.41))
            c.addComposerPicture(pict)

            text = QgsComposerLabel(c)
            text.setFont(font_sub)
            text.setText(u"取水点および放水点の情報")
            text.setItemPosition(196, 30.5)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"新規")
            text.setItemPosition(242, 42)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"前回")
            text.setItemPosition(257, 42)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"前々回")
            text.setItemPosition(272, 42)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"＜取水点＞")
            text.setItemPosition(194, 46)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"標高(m)")
            text.setItemPosition(197, 51)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.z_Elevation.text(),"p_intComma"))
            text.setItemPosition(237, 51)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.z_Elevation_2.text(),"p_intComma"))
            text.setItemPosition(252, 51)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.z_Elevation_3.text(),"p_intComma"))
            text.setItemPosition(267, 51)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"使用可能水量(m3/s)")
            text.setItemPosition(197, 56)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.z_Qmaxr.text(),"p_flt3"))
            text.setItemPosition(237, 56)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.z_Qmaxr_2.text(),"p_flt3"))
            text.setItemPosition(252, 56)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.z_Qmaxr_3.text(),"p_flt3"))
            text.setItemPosition(267, 56)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"＜放水点＞")
            text.setItemPosition(194, 65)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"標高(m)")
            text.setItemPosition(197, 70)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.h_Elevation.text(),"p_intComma"))
            text.setItemPosition(237, 70)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.h_Elevation_2.text(),"p_intComma"))
            text.setItemPosition(252, 70)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.h_Elevation_3.text(),"p_intComma"))
            text.setItemPosition(267, 70)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"＜有効落差(m)＞")
            text.setItemPosition(194, 79)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Rakusa.text(),"p_flt1"))
            text.setItemPosition(237, 79)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Rakusa_2.text(),"p_flt1"))
            text.setItemPosition(252, 79)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Rakusa_4.text(),"p_flt1"))
            text.setItemPosition(267, 79)
            text.adjustSizeToText()
            c.addItem(text)


            #サブタイトル（導入ポテンシャル計算結果）
            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/simu_info.png")
            pict.setSceneRect(QRectF(194, 97, 89.96, 7.41))
            c.addComposerPicture(pict)

            text = QgsComposerLabel(c)
            text.setFont(font_sub)
            text.setText(u"導入ポテンシャル計算結果")
            text.setItemPosition(196, 97.5)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"＜設備容量＞")
            text.setItemPosition(194, 107)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"設備容量(kW)")
            text.setItemPosition(197, 112)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Setsubi.text(),"p_flt1"))
            text.setItemPosition(237, 112)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Setsubi_3.text(),"p_flt1"))
            text.setItemPosition(252, 112)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Setsubi_4.text(),"p_flt1"))
            text.setItemPosition(267, 112)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"＜概算工事費＞(千円)")
            text.setItemPosition(194, 121)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"発電所建物")
            text.setItemPosition(197, 126)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Hatsudensho.text(),"p_flt1"))
            text.setItemPosition(237, 126)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Hatsudensho_3.text(),"p_flt1"))
            text.setItemPosition(252, 126)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Hatsudensho_4.text(),"p_flt1"))
            text.setItemPosition(267, 126)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"取水施設")
            text.setItemPosition(197, 131)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_ShusuiShisetsu.text(),"p_flt1"))
            text.setItemPosition(237, 131)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_ShusuiShisetsu_3.text(),"p_flt1"))
            text.setItemPosition(252, 131)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_ShusuiShisetsu_4.text(),"p_flt1"))
            text.setItemPosition(267, 131)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"沈砂池・水槽等")
            text.setItemPosition(197, 136)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Chinsachi.text(),"p_flt1"))
            text.setItemPosition(237, 136)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Chinsachi_3.text(),"p_flt1"))
            text.setItemPosition(252, 136)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Chinsachi_4.text(),"p_flt1"))
            text.setItemPosition(267, 136)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"導水施設")
            text.setItemPosition(197, 141)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_DosuiShisetsu.text(),"p_flt1"))
            text.setItemPosition(237, 141)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_DosuiShisetsu_3.text(),"p_flt1"))
            text.setItemPosition(252, 141)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_DosuiShisetsu_4.text(),"p_flt1"))
            text.setItemPosition(267, 141)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"放水施設")
            text.setItemPosition(197, 146)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_HosuiShisetsu.text(),"p_flt1"))
            text.setItemPosition(237, 146)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_HosuiShisetsu_3.text(),"p_flt1"))
            text.setItemPosition(252, 146)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_HosuiShisetsu_4.text(),"p_flt1"))
            text.setItemPosition(267, 146)
            text.adjustSizeToText()
            c.addItem(text)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"機械・電気設備工事費")
            text.setItemPosition(197, 151)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_KikaiDenki.text(),"p_flt1"))
            text.setItemPosition(237, 151)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_KikaiDenki_3.text(),"p_flt1"))
            text.setItemPosition(252, 151)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_KikaiDenki_4.text(),"p_flt1"))
            text.setItemPosition(267, 151)
            text.adjustSizeToText()
            c.addItem(text)

            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/bar.png")
            pict.setSceneRect(QRectF(194, 158, 89.96, 1))
            c.addComposerPicture(pict)

            text = QgsComposerLabel(c)
            text.setFont(font)
            text.setText(u"概算工事費合計")
            text.setItemPosition(197, 159)
            text.adjustSizeToText()
            c.addItem(text)

            # 新規
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Gokei.text(),"p_flt1"))
            text.setItemPosition(237, 159)
            text.adjustSizeToText()
            c.addItem(text)

            # 前回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Gokei_3.text(),"p_flt1"))
            text.setItemPosition(252, 159)
            text.adjustSizeToText()
            c.addItem(text)

            # 前々回
            text = QgsComposerLabel(c)
            text.setFont(font_num)
            text.setText(common.textFormat(self.ui.r_Gokei_4.text(),"p_flt1"))
            text.setItemPosition(267, 159)
            text.adjustSizeToText()
            c.addItem(text)

            #メモ
            pict = QgsComposerPicture(c)
            pict.setPicturePath(os.path.dirname(__file__) + "/print/memo_yoko.png")
            pict.setSceneRect(QRectF(194, 176, 89.96, 23.99))
            c.addComposerPicture(pict)

            printer = QPrinter()
            printer.setOutputFormat(QPrinter.PdfFormat)
            printer.setOutputFileName(filename)
            printer.setPaperSize(QSizeF(c.paperWidth(), c.paperHeight()), QPrinter.Millimeter)
            printer.setFullPage(True)
            printer.setColorMode(QPrinter.Color)
            printer.setResolution(c.printResolution())

            pdfPainter = QPainter(printer)
            paperRectMM = printer.pageRect(QPrinter.Millimeter)
            paperRectPixel = printer.pageRect(QPrinter.DevicePixel)
            c.render(pdfPainter, paperRectPixel, paperRectMM)
            pdfPainter.end()

            if os.name == "nt":
                os.system('start '+filename)
            else:
                os.system('open '+filename)

        except:
            pass

        finally:
            #マウスカーソル戻す
            QApplication.restoreOverrideCursor()
            QApplication.restoreOverrideCursor()    #2回呼び出す必要
