# -*- coding: utf-8 -*-
"""
/***************************************************************************
 HydropowerPotential
                                 A QGIS plugin
 HydropowerPotential
                              -------------------
        begin                : 2017-01-11
        git sha              : $Format:%H$
        copyright            : (C) 2017 by PCKK
        email                : sawai@develop.websheetbox.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtCore, QtGui
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from Search import SearchDialog
from Descript import DescriptDialog
from Simulate import SimulateDialog
from Measure import MeasureDialog
import os.path
import common
import const


class HydropowerPotential:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'HydropowerPotential_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)


        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'HydropowerPotential')

        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'Search')
        self.toolbar.setObjectName(u'Search')

        self.toolbar = self.iface.addToolBar(u'Descript')
        self.toolbar.setObjectName(u'Descript')

        self.toolbar = self.iface.addToolBar(u'Simulate')
        self.toolbar.setObjectName(u'Simulate')

        self.toolbar = self.iface.addToolBar(u'Measure')
        self.toolbar.setObjectName(u'Measure')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('HydropowerPotential', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        #右のドッキングウィジェット定義
        self.apdockwidget=QDockWidget(self.tr(u"HydropowerPotential") , self.iface.mainWindow() )
        self.apdockwidget.setObjectName(self.tr(u"HydropowerPotential"))
        self.apdockwidget.setFixedWidth(430)

        self.scrollArea = QScrollArea()
        self.scrollArea.setObjectName(u"HydropowerPotentialScrollArea")
        self.scrollArea.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)

        self.scrollArea.show()

        self.apdockwidget.setWidget(self.scrollArea)

        icon_path = ':/plugins/HydropowerPotential/SearchIcon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Search'),
            callback=self.search_run,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/HydropowerPotential/DescriptIcon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Descript'),
            callback=self.descript_run,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/HydropowerPotential/SimulateIcon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Simulate'),
            callback=self.simulate_run,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/HydropowerPotential/MeasureIcon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Measure'),
            callback=self.measure_run,
            parent=self.iface.mainWindow())

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'HydropowerPotential'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

        try:
            self.iface.removeDockWidget(self.apdockwidget)
        except:
            pass

    def search_run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.search_dialog = SearchDialog(self.iface, self.apdockwidget, self.scrollArea)
        self.search_dialog.show()

    def descript_run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.descript_dialog = DescriptDialog(self.iface)
        self.scrollArea.setWidget(self.descript_dialog)
        self.iface.addDockWidget( Qt.RightDockWidgetArea, self.apdockwidget )

    def simulate_run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.simulate_dialog = SimulateDialog(self.iface)
        self.scrollArea.setWidget(self.simulate_dialog)
        self.iface.addDockWidget( Qt.RightDockWidgetArea, self.apdockwidget )

    def measure_run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.measure_dialog = MeasureDialog(self.iface)
        self.scrollArea.setWidget(self.measure_dialog)
        self.iface.addDockWidget( Qt.RightDockWidgetArea, self.apdockwidget )

