# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
import const

#from cursor import Cursor


class ClickFeature(QgsMapToolIdentify):
    geomIdentified = pyqtSignal(QgsVectorLayer, QgsFeature, QgsMapMouseEvent)
    pointClicked = pyqtSignal(QgsMapMouseEvent)
    pointDbClicked = pyqtSignal(QgsMapMouseEvent)

    def __init__(self, canvas, pickMode = 'all'):
        print pickMode;

        self.canvas = canvas
        QgsMapToolIdentify.__init__(self, canvas)
        if pickMode == 'all':
            self.selectionMode = self.TopDownStopAtFirst
        elif pickMode == 'selection':
            self.selectionMode = self.LayerSelection
        elif pickMode == 'active':
            self.selectionMode = self.ActiveLayer
        elif pickMode == 'all_list':
            self.selectionMode = self.TopDownAll

    def canvasReleaseEvent(self, mouseEvent):
        '''
        try:
            results = self.identify(mouseEvent.x(), mouseEvent.y(), self.LayerSelection, self.VectorLayer)
        except:
        '''

        #第一発火
        self.pointClicked.emit(mouseEvent)

        #第二発火
        results = self.identify(mouseEvent.x(), mouseEvent.y(), self.selectionMode, self.VectorLayer)
        if len(results) > 0:

            #水路100mセグメントを第1優先取得
            for res in results:
                if res.mLayer.name() == const.ZONE_LYR_NAME:
                    self.geomIdentified.emit(res.mLayer, QgsFeature(res.mFeature), mouseEvent)
                    return

            #仮想発電所リンクを第2優先取得
            for res in results:
                if res.mLayer.name() == const.LINK_LYR_NAME:
                    self.geomIdentified.emit(res.mLayer, QgsFeature(res.mFeature), mouseEvent)
                    return

    def canvasDoubleClickEvent(self, event):
        self.pointDbClicked.emit(event)
